﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_IPHONE
using UnityEngine.iOS;
#endif // UNITY_IPHONE

//	Summary
//		* Indicator를 표시한다.

namespace GameUtility
{
	/*
		Indicator
 	*/
	public class Indicator : MonoBehaviour
	{

		IEnumerator _indicatorCoroutine;
		// indicator coroutine.

		public void ShowIndicator ()
		{
			Debug.Log ("ShowIndicator");

#if !UNITY_EDITOR
		_indicatorCoroutine	= AnimateIndicator();

		StartCoroutine(_indicatorCoroutine);
#endif // !UNITY_EDITOR
		}

		public void HideIndicator ()
		{

			Handheld.StopActivityIndicator ();
#if !UNITY_EDITOR
			if (_indicatorCoroutine != null) {
				StopCoroutine(_indicatorCoroutine);
				_indicatorCoroutine = null;
			}
#endif // !UNITY_EDITOR
		}

		IEnumerator AnimateIndicator ()
		{
#if UNITY_IPHONE
			Handheld.SetActivityIndicatorStyle (ActivityIndicatorStyle.Gray);
#elif UNITY_ANDROID
            Handheld.SetActivityIndicatorStyle(AndroidActivityIndicatorStyle.Small);
#endif

			Handheld.StartActivityIndicator ();
			yield return new WaitForSeconds (1);
			// Application.LoadLevel(1);
		}
	}
}
